/*********************************************************************
 *
 *                  Headers for TCPIP Demo App
 *
 *********************************************************************
 * FileName:        MainDemo.h
 * Dependencies:    Compiler.h
 * Processor:       PIC18, PIC24F, PIC24H, dsPIC30F, dsPIC33F, PIC32
 * Compiler:        Microchip C32 v1.05 or higher
 *					Microchip C30 v3.12 or higher
 *					Microchip C18 v3.30 or higher
 *					HI-TECH PICC-18 PRO 9.63PL2 or higher
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * Copyright (C) 2002-2009 Microchip Technology Inc.  All rights
 * reserved.
 *
 * Microchip licenses to you the right to use, modify, copy, and
 * distribute:
 * (i)  the Software when embedded on a Microchip microcontroller or
 *      digital signal controller product ("Device") which is
 *      integrated into Licensee's product; or
 * (ii) ONLY the Software driver source files ENC28J60.c, ENC28J60.h,
 *		ENCX24J600.c and ENCX24J600.h ported to a non-Microchip device
 *		used in conjunction with a Microchip ethernet controller for
 *		the sole purpose of interfacing with the ethernet controller.
 *
 * You should refer to the license agreement accompanying this
 * Software for additional information regarding your rights and
 * obligations.
 *
 * THE SOFTWARE AND DOCUMENTATION ARE PROVIDED "AS IS" WITHOUT
 * WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT
 * LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * MICROCHIP BE LIABLE FOR ANY INCIDENTAL, SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA, COST OF
 * PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR SERVICES, ANY CLAIMS
 * BY THIRD PARTIES (INCLUDING BUT NOT LIMITED TO ANY DEFENSE
 * THEREOF), ANY CLAIMS FOR INDEMNITY OR CONTRIBUTION, OR OTHER
 * SIMILAR COSTS, WHETHER ASSERTED ON THE BASIS OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE), BREACH OF WARRANTY, OR OTHERWISE.
 *
 *
 * Author               Date    Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * E. Wood				4/26/08 Copied from MainDemo.c
 ********************************************************************/

#include "GenericTypeDefs.h" 
#include "StackTsk.h"

#ifndef _MAINDEMO_H
#define _MAINDEMO_H

//#include "ff.h"

#define FIRMWARE_VERSION		5.41
//#define EMAIL_BODY_SIZE			2048
#define DEBUG_STACK_POSITION	0
#define DEBUG_STACK_HTTP		0
#define DEBUG_STACK_DYNDNS		0
#define DEBUG_SMTP				0     
#define	ADC_INDEX_THRESHOLD		100
#define ADC_CONVERT_THRESHOLD	20000
#define FTP_COMMAND_PORT        21u
#define FTP_DATA_PORT           20u
#define NTP_SERVER_PORT			(123ul)
#define BAUD_RATE       		115200		// default bps
#define NUM_VARS				4
#define MAGIC_HEADER			0xF4		// for the serial interface to the time module add on.
#define DAYLIGHT_SAVING_TIME	1

typedef enum
{
	RESULT_NONE=0,
	RESULT_IP_ADDR,
	RESULT_HIDDEN,
	RESULT_INT,
	RESULT_STRING,
	RESULT_BOOLEAN,
	RESULT_FLOAT,
	RESULT_MAC_ADDR,
	RESULT_SHORT_STRING,
    RESULT_PERMISSION
} RESULT_TYPE;

typedef struct
{
	long* 		type;
	char* 		name;
	BYTE*		value;
	RESULT_TYPE	resultType;
} SETTING;

#define FILE_EXT_LEN    (3u)

typedef struct _FILE_TYPES
{
    BYTE fileExt[FILE_EXT_LEN+1];
} FILE_TYPES;

void SaveAppConfig(void);
void SMTPDemo(void);
void PingDemo(void);
void SNMPTrapDemo(void);
void GenericTCPClient(void);
void GenericTCPServer(void);
void BerkeleyTCPClientDemo(void);
void BerkeleyTCPServerDemo(void);
void BerkeleyUDPClientDemo(void);
float extractFloat(char*);
char* DisplayMACAddr(char*, BYTE*);
void printValueType(char*, RESULT_TYPE, BYTE*, long*);
float getValueType(char*, char*, RESULT_TYPE, BYTE*, long*);
unsigned long myatol(char*);
FRESULT logString(char*, int);
int getValueIndex(char*, SETTING*);
void setValue(int, SETTING*, BYTE*, int);
void updateValues(void);
void getValues(void);
void putValues(void);
int HTTPUnlocked(void);

extern long smtpPort;
extern long ftpPort;
extern long ftpDataPort;
extern long httpPort;
extern long ntpPort;
extern char NTPServer[];
extern char DynDNSServer[];
extern long DynDNSServerPort;
extern char DynDNSUsername[];
extern char DynDNSPassword[];
extern char DynDNSHost[];
extern char DynDNSDynIPServer[];
extern long DynDNSDynIPPort;
extern long NTPTimezone;
extern BYTE defaultbForceUpdate;
extern BYTE emailAddress[];
extern BYTE emailMessageBody[];
extern BYTE emailServer[];
extern BYTE emailFrom[];
extern BYTE emailSubject[];
extern BYTE emailPending;
extern BYTE emailFile[];
extern BYTE emailUser[];
extern BYTE emailPassword[];
extern int NTPTimeActive;
extern VARIABLE_TYPE variable[NUM_VARS];
extern APP_CONFIG AppConfig;
extern BYTE tempString[];
extern BYTE myDHCPBindCount;
extern FATFS 	fileSystem;
extern FIL		fsrc;
extern BYTE	fileBuffer[FILE_BUFFER_SIZE];
extern int 	adcState;
extern int 	adcIndex;
extern char 	variableBuffer[];
extern char 	valueBuffer[];
extern char 	iBuffer[];
extern char    valuesBuffer[];
extern char 	userName[HIDDEN_STRING_MAX];
extern char 	passWord[HIDDEN_STRING_MAX];
extern char	varlogFileName[32];
extern IP_ADDR lastKnownIP;

// An actual function defined in MainDemo.c for displaying the current IP 
// address on the UART and/or LCD.
#define TOTAL_SETTINGS          111
#define TOTAL_FILE_TYPES        13
#define HTTP_UNKNOWN            (TOTAL_FILE_TYPES-1)          
#define IS_EXECUTABLE           4
#define IS_DYNAMIC              2
#define REQ_PASSWORD            1
#define FTP_TIMEOUT             (600ul)

extern SETTING settingsNames[];

#endif
